/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.townhall;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.views.DropDownList;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.WindowBannerPicker;
import com.minecolonies.coremod.client.gui.townhall.AbstractWindowTownHall;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.event.TextureReloadListener;
import com.minecolonies.coremod.network.messages.server.colony.ColonyTextureStyleMessage;
import com.minecolonies.coremod.network.messages.server.colony.TeamColonyColorChangeMessage;
import com.minecolonies.coremod.network.messages.server.colony.ToggleHelpMessage;
import com.minecolonies.coremod.network.messages.server.colony.ToggleHousingMessage;
import com.minecolonies.coremod.network.messages.server.colony.ToggleJobMessage;
import com.minecolonies.coremod.network.messages.server.colony.ToggleMoveInMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.NotNull;

public class WindowSettingsPage
extends AbstractWindowTownHall {
    private static AtomicBoolean isFeatureUnlocked = new AtomicBoolean(false);
    private DropDownList colorDropDownList;
    private DropDownList textureDropDownList;
    private int initialTextureIndex;

    public WindowSettingsPage(BuildingTownHall.View townHall) {
        super(townHall, "layoutsettings.xml");
        this.initColorPicker();
        this.registerButton("toggleJob", this::toggleHiring);
        this.registerButton("toggleHousing", this::toggleHousing);
        this.registerButton("toggleMoveIn", this::toggleMoveIn);
        this.registerButton("togglePrintProgress", this::togglePrintProgress);
        this.registerButton("bannerPicker", this::openBannerPicker);
        this.colorDropDownList.setSelectedIndex(townHall.getColony().getTeamColonyColor().ordinal());
        this.textureDropDownList.setSelectedIndex(TextureReloadListener.TEXTURE_PACKS.indexOf(townHall.getColony().getTextureStyleId()));
        this.initialTextureIndex = this.textureDropDownList.getSelectedIndex();
        this.checkFeatureUnlock();
    }

    private void initColorPicker() {
        this.registerButton("previousColor", this::previousStyle);
        this.registerButton("nextColor", this::nextStyle);
        ((DropDownList)this.findPaneOfTypeByID("colorPicker", DropDownList.class)).setEnabled(this.enabled);
        this.colorDropDownList = (DropDownList)this.findPaneOfTypeByID("colorPicker", DropDownList.class);
        this.colorDropDownList.setHandler(this::onDropDownListChanged);
        final List textColors = Arrays.stream(ChatFormatting.values()).filter(ChatFormatting::m_126664_).collect(Collectors.toList());
        this.colorDropDownList.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return textColors.size();
            }

            public String getLabel(int index) {
                if (index >= 0 && index < textColors.size()) {
                    return ((ChatFormatting)textColors.get(index)).m_126666_();
                }
                return "";
            }
        });
        this.textureDropDownList = (DropDownList)this.findPaneOfTypeByID("textureStylePicker", DropDownList.class);
        this.textureDropDownList.setHandler(this::toggleTexture);
        this.textureDropDownList.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return TextureReloadListener.TEXTURE_PACKS.size();
            }

            public String getLabel(int index) {
                return TextureReloadListener.TEXTURE_PACKS.get(index);
            }
        });
    }

    private void toggleTexture(DropDownList dropDownList) {
        if (dropDownList.getSelectedIndex() != this.initialTextureIndex) {
            Network.getNetwork().sendToServer(new ColonyTextureStyleMessage(((ITownHallView)this.building).getColony(), TextureReloadListener.TEXTURE_PACKS.get(dropDownList.getSelectedIndex())));
        }
    }

    private void onDropDownListChanged(DropDownList dropDownList) {
        Network.getNetwork().sendToServer(new TeamColonyColorChangeMessage(dropDownList.getSelectedIndex(), this.building));
    }

    private void nextStyle() {
        this.colorDropDownList.selectNext();
    }

    private void previousStyle() {
        this.colorDropDownList.selectPrevious();
    }

    @Override
    public void onOpened() {
        super.onOpened();
        if (((ITownHallView)this.building).getColony().isManualHiring()) {
            ((Button)this.findPaneOfTypeByID("toggleJob", Button.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.hiring.on"));
        }
        if (!((ITownHallView)this.building).getColony().isPrintingProgress()) {
            ((Button)this.findPaneOfTypeByID("togglePrintProgress", Button.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.townhall.off"));
        }
        if (((ITownHallView)this.building).getColony().isManualHousing()) {
            ((Button)this.findPaneOfTypeByID("toggleHousing", Button.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.hiring.on"));
        }
        if (((ITownHallView)this.building).getColony().canMoveIn()) {
            ((Button)this.findPaneOfTypeByID("toggleMoveIn", Button.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.townhall.on"));
        }
    }

    private void toggleHiring(@NotNull Button button) {
        boolean toggle;
        String key;
        String string = key = button.getText() instanceof TranslatableComponent ? ((TranslatableComponent)button.getText()).m_131328_() : button.getTextAsString();
        if (key.equals("com.minecolonies.coremod.gui.hiring.off")) {
            button.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.hiring.on"));
            toggle = true;
        } else {
            button.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.hiring.off"));
            toggle = false;
        }
        Network.getNetwork().sendToServer(new ToggleJobMessage(((ITownHallView)this.building).getColony(), toggle));
    }

    private void toggleHousing(@NotNull Button button) {
        boolean toggle;
        String key;
        String string = key = button.getText() instanceof TranslatableComponent ? ((TranslatableComponent)button.getText()).m_131328_() : button.getTextAsString();
        if (key.equals("com.minecolonies.coremod.gui.hiring.off")) {
            button.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.hiring.on"));
            toggle = true;
        } else {
            button.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.hiring.off"));
            toggle = false;
        }
        Network.getNetwork().sendToServer(new ToggleHousingMessage(((ITownHallView)this.building).getColony(), toggle));
    }

    private void toggleMoveIn(@NotNull Button button) {
        boolean toggle;
        String key;
        String string = key = button.getText() instanceof TranslatableComponent ? ((TranslatableComponent)button.getText()).m_131328_() : button.getTextAsString();
        if (key.equals("com.minecolonies.coremod.gui.townhall.off")) {
            button.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.townhall.on"));
            toggle = true;
        } else {
            button.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.townhall.off"));
            toggle = false;
        }
        Network.getNetwork().sendToServer(new ToggleMoveInMessage(((ITownHallView)this.building).getColony(), toggle));
    }

    private void togglePrintProgress(@NotNull Button button) {
        String key;
        String string = key = button.getText() instanceof TranslatableComponent ? ((TranslatableComponent)button.getText()).m_131328_() : button.getTextAsString();
        if (key.equals("com.minecolonies.coremod.gui.townhall.off")) {
            button.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.townhall.on"));
        } else {
            button.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.townhall.off"));
        }
        Network.getNetwork().sendToServer(new ToggleHelpMessage(((ITownHallView)this.building).getColony()));
    }

    private void openBannerPicker(@NotNull Button button) {
        WindowBannerPicker window = new WindowBannerPicker(((ITownHallView)this.building).getColony(), this);
        Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().m_91152_(window));
    }

    @Override
    protected String getWindowId() {
        return "settings";
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        Pane pane = this.findPaneByID("textureStylePicker");
        if (isFeatureUnlocked.get()) {
            pane.enable();
        } else {
            pane.disable();
            AbstractTextBuilder.TooltipBuilder hoverText = PaneBuilders.tooltipBuilder().hoverPane(pane);
            ((AbstractTextBuilder.TooltipBuilder)hoverText.append((MutableComponent)new TranslatableComponent("com.minecolonies.core.townhall.patreon"))).paragraphBreak();
            hoverText.build();
        }
    }

    public void checkFeatureUnlock() {
        String player = Minecraft.m_91087_().f_91074_.m_20149_();
        new Thread(() -> {
            try {
                String inputLine;
                SSLSocketFactory sslsocketfactory = HttpsURLConnection.getDefaultSSLSocketFactory();
                URL url = new URL("https://auth.minecolonies.com/api/minecraft/" + player + "/features");
                HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
                conn.setSSLSocketFactory(sslsocketfactory);
                InputStream responseBody = conn.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(responseBody));
                StringBuilder response = new StringBuilder();
                while ((inputLine = reader.readLine()) != null) {
                    response.append(inputLine);
                }
                reader.close();
                isFeatureUnlocked.set(Boolean.parseBoolean(response.toString()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
    }
}

